package gov.va.genisis2.ts.utils;

import java.util.Objects;

public class Uri2Name {
	public static String extractOntology(String uri) {
		if (uri.startsWith("http://snomed"))
			return "snomed-ct";
		if (uri.startsWith("http://ncicb"))
			return "ncicb";
		if (uri.startsWith("http://rdf.cdisc.org"))
			return "cdisc";
		if (uri.startsWith("http://purl.obolibrary.org/obo/doid"))
			return "doid";
		if (uri.startsWith("http://www.geneontology.org/format/oboInOwl"))
			return "hp";
		if (uri.startsWith("http://purl.bioontology.org/ontology/HOM-ICD9CM"))
			return "icd-9";
		if (uri.startsWith("http://purl.bioontology.org/ontology/ICD10CM"))
			return "icd-10";
		if (uri.startsWith("http://www.semanticweb.org/ontologies/2012/8/Ontology1347204983370"))
			return "survey";
		return "unknown ontology";
	}

	public static String extractNameFromUri(String uri) {
		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P357", uri))
			return "Essential_Fatty_Acid";

		if (Objects.equals("http://purl.bioontology.org/ontology/ICD10CM/MAPSETXRTARGETID", uri))
			return "MAPSETXRTARGETID";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P369", uri))
			return "HGNC_ID";

		if (Objects.equals("http://www.geneontology.org/formats/oboInOwl#hasExactSynonym", uri))
			return "has_exact_synonym";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P317", uri ))
			return "FDA_Table";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P208", uri))
			return "NCI_META_CUI";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P329", uri ))
			return "PDQ_Open_Trial_Search_ID";

		if (Objects.equals("http://www.geneontology.org/formats/oboInOwl#hasOBOFormatVersion", uri ))
			return "has_obo_format_version";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A6", uri ))
			return "Has_Free_Acid_Or_Base_Form";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A5", uri ))
			return "Has_Salt_Form";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#NHC4", uri ))
			return "Split_From";

		if (Objects.equals("http://www.geneontology.org/formats/oboInOwl#hasRelatedSynonym", uri))
			return "has_related_synonym";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P171", uri ))
			return "PubMedID_Primary_Reference";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P361", uri ))
			return "Extensible_List";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/SOS", uri ))
			return "Scope Statement";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P385", uri ))
			return "source-code";

		if (Objects.equals("http://purl.bioontology.org/ontology/ICD10CM/MAPSETRSAB", uri ))
			return "MAPSETRSAB";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P167", uri ))
			return "Image_Link";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P200", uri ))
			return "OLD_PARENT";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P321", uri ))
			return "EntrezGene_ID";

		if (Objects.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P333", uri ))
			return "Use_For";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P90", uri))
			return "FULL_SYN";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#SynonymTypeProperty", uri))
			return "synonym_type_property";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P368", uri))
			return "CHEBI_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P316", uri))
			return "Relative_Enzyme_Activity";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P207", uri))
			return "UMLS_CUI";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P98", uri))
			return "DesignNote";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/FROMVSAB", uri))
			return "FROMVSAB";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#hasSynonymType", uri))
			return "has_synonym_type";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A7", uri))
			return "Has_Target";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P360", uri))
			return "Macronutrient";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P384", uri))
			return "term-source";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P320", uri))
			return "OID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P211", uri))
			return "GO_Annotation";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P332", uri))
			return "MGI_Accession_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P102", uri))
			return "GenBank_Accession_Number";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P356", uri))
			return "Essential_Amino_Acid";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P359", uri))
			return "Micronutrient";

		if (Objects.equals( "http://www.w3.org/2000/01/rdf-schema#comment", uri))
			return "comment";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P319", uri))
			return "FDA_UNII_Code";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MAPSETVSAB", uri))
			return "MAPSETVSAB";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MTH_MAPTOEXHAUSTIVE", uri))
			return "MTH MAPTOEXHAUSTIVE";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A3", uri))
			return "Role_Has_Parent";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P92", uri))
			return "Subsource";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P351", uri))
			return "US_Recommended_Intake";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P363", uri))
			return "Neoplastic_Status";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P387", uri))
			return "go-id";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P358", uri))
			return "Nutrient";

		if (Objects.equals( "http://bioportal.bioontology.org/ontologies/umls/hasSTY", uri))
			return "Semantic type UMLS property";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/USE_ADDITIONAL", uri))
			return "USE ADDITIONAL";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#hasAlternativeId", uri))
			return "has_alternative_id";

		if (Objects.equals( "http://purl.obolibrary.org/obo/IAO_0000115", uri))
			return "definition";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/TOVSAB", uri))
			return "TOVSAB";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MTH_MAPTOCOMPLEXITY", uri))
			return "MTH MAPTOCOMPLEXITY";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A4", uri))
			return "Qualifier_Applies_To";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/FROMRSAB", uri))
			return "FROMRSAB";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/ORDER_NO", uri))
			return "Order number";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P350", uri))
			return "Chemical_Formula";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#hasOBONamespace", uri))
			return "has_obo_namespace";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P362", uri))
			return "miRBase_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P386", uri))
			return "subsource-name";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P310", uri))
			return "Concept_Status";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P201", uri))
			return "OLD_CHILD";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P322", uri))
			return "Contributing_Source";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P334", uri))
			return "ICD-O-3_Code";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P204", uri))
			return "OLD_ROLE";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P325", uri))
			return "ALT_DEFINITION";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P107", uri))
			return "Display_name";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P216", uri))
			return "BioCarta_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P390", uri))
			return "go-source";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/EXCLUDES2", uri))
			return "EXCLUDES2";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MTH_MAPFROMEXHAUSTIVE", uri))
			return "MTH MAPFROMEXHAUSTIVE";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#NHC0", uri))
			return "code";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#hasBroadSynonym", uri))
			return "has_broad_synonym";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A1", uri))
			return "Role_Has_Domain";
		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P381", uri))
			return "attr";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MTH_MAPFROMCOMPLEXITY", uri))
			return "MTH MAPFROMCOMPLEXITY";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P175", uri))
			return "NSC_Code";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P353", uri))
			return "INFOODS";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#hasDbXref", uri))
			return "database_cross_reference";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A11", uri))
			return "Has_NICHD_Parent";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P389", uri))
			return "go-evi";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P203", uri))
			return "OLD_KIND";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P215", uri))
			return "KEGG_ID";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#hasNarrowSynonym", uri))
			return "has_narrow_synonym";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MAPSETVERSION", uri))
			return "MAPSETVERSION";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P106", uri))
			return "Semantic_Type";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#inSubset", uri))
			return "in_subset";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/TORSAB", uri))
			return "TORSAB";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P391", uri))
			return "source-date";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/SIB", uri))
			return "Inverse of SIB";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/EXCLUDES1", uri))
			return "EXCLUDES1";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A2", uri))
			return "Role_Has_Range";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P93", uri))
			return "Swiss_Prot";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P352", uri))
			return "Tolerable_Level";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P364", uri))
			return "OLD_ASSOCIATION";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P315", uri))
			return "SNP_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P97", uri))
			return "DEFINITION";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#logical-definition-view-relation", uri))
			return "logical-definition-view-relation";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/CODE_FIRST", uri))
			return "CODE FIRST";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A8", uri))
			return "Concept_In_Subset";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P371", uri))
			return "NICHD_Hierarchy_Term";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P383", uri))
			return "term-group";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P101", uri))
			return "Homologous_Gene";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P210", uri))
			return "CAS_Registry";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P331", uri))
			return "NCBI_Taxon_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A13", uri))
			return "Related_To_Genetic_Biomarker";

		if (Objects.equals( "http://purl.obolibrary.org/obo/IAO_0100001", uri))
			return "term replaced by";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P355", uri))
			return "Unit";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P367", uri))
			return "PID_ID";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/MTH_MAPSETCOMPLEXITY", uri))
			return "MTH MAPSETCOMPLEXITY";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P302", uri))
			return "Accepted_Therapeutic_Use_For";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P205", uri))
			return "OLD_STATE";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P96", uri))
			return "Gene_Encodes_Product";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P108", uri))
			return "Preferred_Name";

		if (Objects.equals( "http://www.w3.org/2000/01/rdf-schema#label", uri))
			return "label";

		if (Objects.equals( "http://purl.bioontology.org/ontology/ICD10CM/CODE_ALSO", uri))
			return "CODE ALSO";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A9", uri))
			return "Is_Related_To_Endogenous_Product";

		if (Objects.equals( "http://www.geneontology.org/formats/oboInOwl#consider", uri))
			return "consider";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P330", uri))
			return "PDQ_Closed_Trial_Search_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P100", uri))
			return "OMIM_Number";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P354", uri))
			return "USDA_ID";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#A12", uri))
			return "Has_Data_Element";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P366", uri))
			return "Legacy_Concept_Name";

		if (Objects.equals( "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P378", uri))
			return "def-source";

		// Predicates with no labels
		//
		int hashDelimiterIdx = uri.lastIndexOf('#');
		if (hashDelimiterIdx > 0)
			return uri.substring(hashDelimiterIdx + 1);
		int slashIdx = uri.lastIndexOf('/');
		if (slashIdx > 0)
			return uri.substring(slashIdx + 1);

		return uri;
	}
}
